	 function Taug = LTH_BAND_14_15_TAUG(x, wT)
	 
	 % Function for Example 14.15
	 
	 % 	Toolbox for DIGITAL FILTERS USING MATLAB 
	 
	 % 	Author: 		Lars Wanhammar 2011-02-11
	 % 	Modified by: 	 
	 % 	Copyright:		by authors - not released for commercial use
	 % 	Version:		1
	 % 	Known bugs:		 
	 % 	Report bugs to:	Wanhammar@gmail.com
	 
	 
	 P0 = [1 0 0 0 0 0 0 0 0 0];
	 Taug0 = PZ_2_TG_Z(1, [], roots(P0), wT); 
	 
	 N1 = conv([-x(1) 0 0 0 0 1],[-x(2) 0 0 0 0 1]);
	 P1 = [fliplr(N1)];
	 Taug1 = PZ_2_TG_Z(1, roots(N1), roots(P1), wT);
	 
	 N2 = conv([-x(3) 0 0 0 0 1],[-x(4) 0 0 0 0 1]);
	 P2 = [fliplr(N2)];
	 Taug2 = PZ_2_TG_Z(1, roots(N2), [roots(P2)' 0], wT);
	 
	 N3 = conv([-x(5) 0 0 0 0 1],[-x(6) 0 0 0 0 1]);
	 P3 = [fliplr(N3)];	 
	 Taug3 = PZ_2_TG_Z(1, roots(N3), [roots(P3)' 0 0], wT);
	 
	 N4 = conv([-x(7) 0 0 0 0 1],[-x(8) 0 0 0 0 1]);
	 P4 = [fliplr(N4)];
	 Taug4 = PZ_2_TG_Z(1, roots(N4), [roots(P4)' 0 0 0], wT); 
	 % Note that the group delays adds
	 Taug =  (Taug0+ Taug1+ Taug2+ Taug3+ Taug4)/5;
	 
